#ifndef _LIB_EDITORTOOLS_H_
#define _LIB_EDITORTOOLS_H_

#include "c4d_library.h"

class LassoSelection;

// example implementation objectlist public stuff

// C4DObjectList:
// contains a list of objects
// Alloc() - allocates the object
// Free() - destroys the object
// GetCount() - returns the number of objects
// GetObject() - returns the object
// GetZ() - returns the Z depth of the object from the camera
// AddObject() - adds an object to the list

class C4DObjectList
{
	private:
		C4DObjectList();
	public:
		static C4DObjectList* Alloc();
		static void Free(C4DObjectList *&ptr);

		LONG GetCount();
		BaseObject*	GetObject(LONG num);
		Real GetZ(LONG num);
		LONG GetPolyIdx(LONG num);

		Bool AddObject(BaseObject *op, Real z, LONG polynum);
};

// SelectionListCreate:
// creates a valid objectlist for a given coordinate (mx,my) for a specific basedraw (bd)
// return: true = successful, false: any kind of error,
// list the contains a sorted list of all objects [0] is the closest object [cnt-1] the farest object
// the lasso selection class is optional
Bool SelectionListCreate(BaseDocument *doc, BaseObject *parent, BaseDraw *bd, Real mx, Real my, LassoSelection *ls, C4DObjectList *list);

// SelectionListShowMenu:
// shows a popupmenu with of the given objectlist and lets the user choose
// screenx&y = "MOUSEPOS" means automatic position
// result: the number of the element in the objectlist, -1 means nothing or aborted
LONG SelectionListShowMenu(BaseDocument *doc, Real screenx, Real screeny, C4DObjectList *list);





// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF

#define LIBRARY_OBJECTLIST		1000464

class C4DObjectList;

struct ObjectListLib : public C4DLibrary
{
	C4DObjectList* (*ObjectList_Alloc      )();
	void        (*ObjectList_Free       )(C4DObjectList *ptr);
	LONG				(*ObjectList_GetCount   )(C4DObjectList *ptr);
	BaseObject*	(*ObjectList_GetObject  )(C4DObjectList *ptr, LONG num);
	Real				(*ObjectList_GetZ       )(C4DObjectList *ptr, LONG num);
	Bool        (*ObjectList_AddObjectEx)(C4DObjectList *ptr, BaseObject *op, Real z);
	Bool        (*ObjectList_AddObject  )(C4DObjectList *ptr, BaseObject *op, Real z, LONG polynum);
	LONG				(*ObjectList_GetPolyIdx )(C4DObjectList *ptr, LONG num);
};

// example implementation editor tools, internal stuff

#define LIBRARY_EDITORTOOLS		1000465

struct EditorToolLib : public C4DLibrary
{
	Bool				(*SelectionListCreate   )(BaseDocument *doc, BaseObject *parent, BaseDraw *bd, Real mx, Real my, LassoSelection *ls, C4DObjectList *list);
	LONG        (*SelectionListShowMenu )(BaseDocument *doc, Real screenx, Real screeny, C4DObjectList *list);
};

// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF

#endif
